import numpy as np
from math import *
import define_experiment as exp
import scipy.interpolate as sci
import subfunctions as sf
import matplotlib.pyplot as plt


rover = {'wheel_assembly': {'wheel': {'radius': 0.3, 'mass': 1},
                            'speed_reducer': {'type': 'reverted', 'diam_pinion': 0.05, 'diam_gear': 0.08, 'mass': 1.50},
                            'motor': {'torque_stall': 175, 'torque_noload': 0, 'speed_noload': 3.9, 'mass': 5,
                                      'effcy_tau': np.array([0, 10, 20, 40, 70, 165]), 'effcy': np.array([0, 0.55, 0.75, 0.71, 0.5, 0.05])}},
         'chassis': {'mass': 659}, 'science_payload': {'mass': 75}, 'power_subsys': {'mass': 90}}
planet = {'g': 3.72}
experiment1 = exp.experiment1()
experiment = experiment1[0]
end_event = experiment1[1]

tau = rover['wheel_assembly']['motor']['effcy_tau']
effc = rover['wheel_assembly']['motor']['effcy']
tau_100 = np.linspace(min(tau), max(tau), 100)
effcy_100 = []
effcy_fun = sci.interp1d(tau, effc, kind = 'cubic', fill_value='extrapolate') # fit the cubic spline

for i in range(len(tau_100)):
    effc_val = effcy_fun(tau_100[i].item())
    effcy_100.append(effc_val)

plt.plot(tau_100, effcy_100, 'k-')
plt.plot(tau, effc, 'r*')
plt.xlabel('Torque (Nm)')
plt.ylabel('Efficiency')
plt.show()